#ifndef SUBDOMAINS_H
#define SUBDOMAINS_H

#include <dolfin.h>

const double eps = DOLFIN_EPS;

class DomainXY0: public SubDomain
{
public:
  bool inside(const double* x, bool on_boundary) const
  {
    return x[0] < eps && x[1] < eps;
  }
};

class DomainXYZ0: public SubDomain
{
public:
  bool inside(const double* x, bool on_boundary) const
  {
    return x[0] < eps && x[1] < eps && x[2] < eps;
  }
};

class Side0: public SubDomain
{
  int side;
  double value;

public:
  Side0(int side, double value):
    side(side), value(value)
  {}

  bool inside(const double* x, bool on_boundary) const
  {
    return x[side] < value + eps;
  }
};

class Side1: public SubDomain
{
  int side;
  double value;

public:
  Side1(int side, double value):
    side(side), value(value)
  {}

  bool inside(const double* x, bool on_boundary) const
  {
    return x[side] > value - eps;
  }
};

class PressureBoundary: public SubDomain
{
  bool inside(const double* x, bool on_boundary) const
  {
    //return (x[0] < eps) || (x[0] > 1.0-eps) || (x[1] < eps) || (x[1] > 1.0-eps) || (x[2] < eps) || (x[2] > 1.0-eps);
    return false;
  }
};

class DirichletBoundary: public SubDomain
{
  bool inside(const double* x, bool on_boundary) const
  {
    //return x[0] < DOLFIN_EPS || x[0] > 1.0-DOLFIN_EPS;
    return (x[0] < eps) || (x[0] > 1.0-eps) || (x[1] < eps) || (x[1] > 1.0-eps) || (x[2] < eps) || (x[2] > 1.0-eps);
  }
};

#endif
